/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.modifier;

import java.util.List;
import javax.annotation.Nonnull;
import mrthomas20121.tinkers_reforged.TinkersReforgedConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class AdaptatingModifier
extends Modifier {
    private final ResourceLocation KEY = new ResourceLocation("tinkers_reforged", "adapting_mod");

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            return damage + value;
        }
        return super.getEntityDamage(tool, level, context, baseDamage, damage);
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            event.setNewSpeed(event.getOriginalSpeed() + value);
        }
    }

    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.KEY);
    }

    public int afterEntityHit(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float damageDealt) {
        ModDataNBT persistantData = tool.getPersistentData();
        LivingEntity target = context.getLivingTarget();
        if (target != null && target.m_21224_() && damageDealt > 0.0f && (target.m_6336_().equals(MobType.f_21641_) || target.m_6336_().equals(MobType.f_21642_) || target instanceof Creeper)) {
            if (persistantData.contains(this.KEY, 5)) {
                if (persistantData.getFloat(this.KEY) < ((Float)TinkersReforgedConfig.COMMON.adaptingModifierCap.get()).floatValue()) {
                    persistantData.putFloat(this.KEY, persistantData.getFloat(this.KEY) + 0.25f);
                }
            } else {
                persistantData.putFloat(this.KEY, 0.25f * (float)level);
            }
        }
        return super.afterEntityHit(tool, level, context, damageDealt);
    }

    public void addInformation(@Nonnull IToolStackView tool, int level, @Nullable Player player, @Nonnull List<Component> tooltip, @Nonnull TooltipKey tooltipKey, @Nonnull TooltipFlag tooltipFlag) {
        if (player != null) {
            ModDataNBT persistantData = tool.getPersistentData();
            if (persistantData.contains(this.KEY, 5)) {
                float value = persistantData.getFloat(this.KEY);
                if (value == ((Float)TinkersReforgedConfig.COMMON.adaptingModifierCap.get()).floatValue()) {
                    this.addDamageTooltip(tool, value, tooltip);
                    this.addSpeedTooltip(tool, value, tooltip);
                    tooltip.add((Component)new TranslatableComponent("modifier.tinkers_reforged.adapting.cap").m_130940_(ChatFormatting.RED));
                } else {
                    this.addDamageTooltip(tool, value, tooltip);
                    this.addSpeedTooltip(tool, value, tooltip);
                }
            } else {
                this.addDamageTooltip(tool, 0.0f, tooltip);
                this.addSpeedTooltip(tool, 0.0f, tooltip);
            }
        }
    }

    protected void addSpeedTooltip(IToolStackView tool, float amount, List<Component> tooltip) {
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.MELEE_OR_UNARMED, amount, tooltip);
    }
}

